//=============================================================================
//              |
// Headerfile   |  ftErrCode.h
//              |
// Description  |  Definition of error codes
//              |
//-----------------------------------------------------------------------------
// Disclaimer - Exclusion of Liability
//
// This software is distributed in the hope that it will be useful,but WITHOUT 
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
// FITNESS FOR A PARTICULAR PURPOSE. It can be used an modified by anyone
// free of any license obligations or authoring rights.
//=============================================================================

#ifndef __FTERRCODE_H__
#define __FTERRCODE_H__

//---   FTLIB Error Codes

#define FTLIB_ERR_SUCCESS                   0x00000000L
#define FTLIB_ERR_NO_MEMORY                 0xE0000100L

#define FTLIB_ERR_FAILED                    0xE0001000L
#define FTLIB_ERR_TIMEOUT                   0xE000100CL
#define FTLIB_ERR_INVALID_PARAM             0xE0001018L

#define FTLIB_ERR_SOME_DEVICES_ARE_OPEN     0xE0001101L
#define FTLIB_ERR_DEVICE_IS_OPEN            0xE0001102L
#define FTLIB_ERR_DEVICE_NOT_OPEN           0xE0001103L
#define FTLIB_ERR_NO_SUCH_DEVICE_INSTANCE   0xE0001104L

#define FTLIB_ERR_UNKNOWN_DEVICE_HANDLE     0xE0001283L
#define FTLIB_ERR_LIB_IS_INITIALIZED        0xE0001286L
#define FTLIB_ERR_LIB_IS_NOT_INITIALIZED    0xE0001287L
#define FTLIB_ERR_THREAD_NOT_STARTABLE      0xE00012A0L
#define FTLIB_ERR_THREAD_IS_RUNNING         0xE00012A5L
#define FTLIB_ERR_THREAD_NOT_RUNNING        0xE00012A6L
#define FTLIB_ERR_THREAD_SYNCHRONIZED       0xE00012AFL

#define FTLIB_ERR_TIMEOUT_TA                0xE00012B0L
#define FTLIB_ERR_CREATE_EVENT              0xE00012B1L
#define FTLIB_ERR_CREATE_MM_TIMER           0xE00012B2L

#define FTLIB_ERR_UPLOAD_FILE_NOT_OPEN      0xE0001400L
#define FTLIB_ERR_UPLOAD_FILE_READ_ERR      0xE0001401L
#define FTLIB_ERR_UPLOAD_INVALID_FSIZE      0xE0001402L
#define FTLIB_ERR_UPLOAD_START              0xE0001403L
#define FTLIB_ERR_UPLOAD_CANCELED           0xE0001404L
#define FTLIB_ERR_UPLOAD_FAILED             0xE0001405L
#define FTLIB_ERR_UPLOAD_TIMEOUT            0xE0001406L
#define FTLIB_ERR_UPLOAD_ACK                0xE0001407L
#define FTLIB_ERR_UPLOAD_NAK                0xE0001408L
#define FTLIB_ERR_UPLOAD_DONE               0xE0001409L
#define FTLIB_ERR_UPLOAD_FLASHWRITE         0xE000140AL
#define FTLIB_ERR_REM_CMD_FAILED            0xE000140BL
#define FTLIB_ERR_REM_CMD_NOT_SUPPORTED     0xE000140CL
#define FTLIB_ERR_FWUPD_GET_FILES           0xE000140DL
#define FTLIB_ERR_FWUPD_NO_FILES            0xE000140EL

#define FTLIB_ERR_ACCESS_DENIED             0xE0001905L
#define FTLIB_ERR_OPEN_COM                  0xE0001906L
#define FTLIB_ERR_INIT_COM                  0xE0001908L
#define FTLIB_ERR_INIT_COM_TIMEOUT          0xE0001909L

#define FTLIB_ERR_WRONG_HOSTNAME_LEN        0xE0002000L

#define FTLIB_FWUPD_UPLOAD_START            0xE0003000L
#define FTLIB_FWUPD_UPLOAD_DONE             0xE0003001L
#define FTLIB_FWUPD_TIMEOUT                 0xE0003002L
#define FTLIB_FWUPD_FLUSH_DISK              0xE0003003L
#define FTLIB_FWUPD_CLEAN_DISK              0xE0003004L
#define FTLIB_FWUPD_ERR_FILE_READ           0xE0003005L
#define FTLIB_FWUPD_UPLOAD_FAILED           0xE0003006L
#define FTLIB_FWUPD_STARTING                0xE0003007L
#define FTLIB_FWUPD_FINISHED                0xE0003008L
#define FTLIB_FWUPD_REM_COMMAND             0xE0003009L
#define FTLIB_FWUPD_REM_TIMEOUT             0xE000300AL
#define FTLIB_FWUPD_REM_FAILED              0xE000300BL
#define FTLIB_FWUPD_IZ_STEPS                0xE000300CL
#define FTLIB_FWUPD_STEP                    0xE000300DL

#define FTLIB_BT_INVALID_CONIDX             0xE0004000L
#define FTLIB_BT_CON_NOT_EXISTS             0xE0004001L
#define FTLIB_BT_CON_ACTIVE                 0xE0004002L
#define FTLIB_BT_CON_INACTIVE               0xE0004003L
#define FTLIB_BT_CON_WRONG_ADDR             0xE0004004L
#define FTLIB_BT_CON_WAIT_BUSY              0xE0004005L

#define FTLIB_I2C_INVALID_DEV_ADDR          0xE0005000L
#define FTLIB_I2C_INVALID_FLAGS_ADDRMODE    0xE0005001L
#define FTLIB_I2C_INVALID_FLAGS_DATAMODE    0xE0005002L
#define FTLIB_I2C_INVALID_FLAGS_ERRMODE     0xE0005003L

#define FTLIB_ERR_UNKNOWN                   0xEFFFFFFFL


#endif
